-- Custom Pause Menu mod made by Blocky.cmd

local zero = {x=0,y=0,z=0}
local m = gMarioStates[0]
local np = gNetworkPlayers[0]
local restartLevelArea = 1
local isPaused = false

--* thanks coolio for the hook & function overwriting

local function is_game_paused_modded()
    return isPaused
end

_G.is_game_paused = is_game_paused_modded

local pause_exit_funcs = {}

local real_hook_event = hook_event
local function hook_event_modded(hook, func)
    if hook == HOOK_ON_PAUSE_EXIT then
        table.insert(pause_exit_funcs, func)
    else
        return real_hook_event(hook, func)
    end
end
_G.hook_event = hook_event_modded

local function call_pause_exit_hooks(exitToCastle)
    local allowExit = true
    for _, func in ipairs(pause_exit_funcs) do
        if func(exitToCastle) == false then
            allowExit = false
            break
        end
    end
    return allowExit
end

local play_sound,save_file_get_star_flags,level_trigger_warp,warp_to_warpnode,djui_hud_set_resolution,djui_hud_set_font,
      djui_hud_get_screen_height,djui_hud_get_screen_width,djui_hud_set_color,djui_hud_render_rect,course_is_main_course,get_level_name,
      get_star_name,save_file_get_course_star_count,get_current_save_file_num,save_file_get_course_coin_score,djui_hud_measure_text,
      djui_hud_print_text,obj_count_objects_with_behavior_id,djui_open_pause_menu =
      play_sound,save_file_get_star_flags,level_trigger_warp,warp_to_warpnode,djui_hud_set_resolution,djui_hud_set_font,
      djui_hud_get_screen_height,djui_hud_get_screen_width,djui_hud_set_color,djui_hud_render_rect,course_is_main_course,get_level_name,
      get_star_name,save_file_get_course_star_count,get_current_save_file_num,save_file_get_course_coin_score,djui_hud_measure_text,
      djui_hud_print_text,obj_count_objects_with_behavior_id,djui_open_pause_menu

local selectedOption = 1

local function close_menu()
    if isPaused then
        isPaused = false
        play_sound(SOUND_MENU_PAUSE_HIGHPRIO, zero)
        m.controller.buttonPressed = 0
    end
end

local cooldown = 5
local cooldownCounter = 0

local previousStickY = 0

function loop_var(var, min, max)
    if var > max then
        var = min
    elseif var < min then
        var = max
    end
    return var
end

local function menu_controls(options)
    local stickY = gMarioStates[0].controller.stickY

    if stickY * previousStickY <= 0 then
        cooldownCounter = cooldownCounter // 2
    end

    if cooldownCounter > 0 then
        cooldownCounter = cooldownCounter - 1
    else
        local delta = options and 1 or -1
        if stickY > 0.5 then
            selectedOption = (selectedOption - delta)
            if options then
                selectedOption = loop_var(selectedOption, 1, #options)
            else
                selectedOption = loop_var(selectedOption, 0, COURSE_MAX)
            end
            play_sound(SOUND_MENU_CHANGE_SELECT, zero)
            cooldownCounter = cooldown
        elseif stickY < -0.5 then
            selectedOption = (selectedOption + delta)
            if options then
                selectedOption = loop_var(selectedOption, 1, #options)
            else
                selectedOption = loop_var(selectedOption, 0, COURSE_MAX)
            end
            play_sound(SOUND_MENU_CHANGE_SELECT, zero)
            cooldownCounter = cooldown
        end
    end

    if gMarioStates[0].controller.buttonPressed & A_BUTTON ~= 0 and options then
        play_sound(SOUND_MENU_CLICK_FILE_SELECT, gMarioStates[0].pos)
        local option = options[selectedOption]
        if option and option.func then
            option.func()
        end
    end

    previousStickY = stickY
end


local function is_star_collected(fileIndex, courseIndex, starId)
    if fileIndex < 0 or courseIndex < -1 or starId < 0 then
        return false
    end

    local currentLevelStarFlags = save_file_get_star_flags(fileIndex, courseIndex)

    return (currentLevelStarFlags & (1 << starId)) ~= 0
end

local function round_start()
    if call_pause_exit_hooks(true) and gGlobalSyncTable.roundState ~= ROUND_STATE_ACTIVE and network_is_server() or network_is_moderator() then
        gGlobalSyncTable.roundState = ROUND_STATE_ACTIVE
        close_menu()
    else
        play_sound(SOUND_MENU_CAMERA_BUZZ, zero)
    if network_is_server() or network_is_moderator() then		
        djui_chat_message_create("\\#ff3030\\The round is already started")	
        end		
    end
end

local function round_reset()
    if call_pause_exit_hooks(false) and gGlobalSyncTable.roundState == ROUND_STATE_ACTIVE and network_is_server() or network_is_moderator() then
        network_send(true, { restart = true })
        level_restart()
	
    if gGlobalSyncTable.popups == true then	
       djui_popup_create_global("Reseting the round...", 1)	
	end   		
        close_menu()
    else
        play_sound(SOUND_MENU_CAMERA_BUZZ, zero)
    if network_is_server() or network_is_moderator() then				
        djui_chat_message_create("\\#ff3030\\The round need to be started to be reseted")
		end
    end
end

local function round_end()
    if call_pause_exit_hooks(true) and gGlobalSyncTable.roundState == ROUND_STATE_ACTIVE and network_is_server() or network_is_moderator()then
        gGlobalSyncTable.roundState = ROUND_STATE_END
		if gPlayerSyncTable[0].finished == true then
        gGlobalSyncTable.level = gGlobalSyncTable.level + 1		
		end
    if gGlobalSyncTable.popups == true then	
       djui_popup_create_global("Ending the round...", 1)	
	end   		
        close_menu()
    else
        play_sound(SOUND_MENU_CAMERA_BUZZ, zero)
    if network_is_server() or network_is_moderator() then				
        djui_chat_message_create("\\#ff3030\\The round need to be started to be ended")
        end	
    end
end

local function random_round()
    if call_pause_exit_hooks(true) and network_is_server() or network_is_moderator() then
    gGlobalSyncTable.level = math.random(#gLevels)
    round_start()
    if gGlobalSyncTable.popups == true then	
       djui_popup_create_global("Starting a random round...", 1)	
	end   		
        close_menu()
    else
        play_sound(SOUND_MENU_CAMERA_BUZZ, zero)	
        djui_chat_message_create("\\#ff3030\\To start a random round the round need to be ended")			
    end
end

local function round_skip()
    if call_pause_exit_hooks(true) and network_is_server() or network_is_moderator() then
       gGlobalSyncTable.roundState = ROUND_STATE_ACTIVE	
       gGlobalSyncTable.level = gGlobalSyncTable.level + 1
    if gGlobalSyncTable.popups == true then	
       djui_popup_create_global("Skipping this round...", 1)	
	end   
       close_menu()
    else
        play_sound(SOUND_MENU_CAMERA_BUZZ, zero)
        djui_chat_message_create("\\#ff3030\\The round need to be ended to be skipped")		
    end
end

local pauseMenuLevelOptions = {
    {name = "ROUND START",  func = round_start},	
    {name = "ROUND RESET",  func = round_reset},	
    {name = "ROUND SKIP",   func = round_skip},					
    {name = "ROUND END",    func = round_end},	
    {name = "RANDOM ROUND", func = random_round},			
}

local function open_cs()
    _G.charSelect.set_menu_open(true)			
    close_menu()
end

local function render_options(options, screenHeight, screenWidth, optionPosY)
    local arrowUp = ""
    local arrowDown = ""
    if #options > 4 then
        if selectedOption > 4 then
            arrowUp = "^"
        end
        if selectedOption <= #options - 1 then
            arrowDown = "v"
        end
    end

    local startOptionIndex = math.max(selectedOption - 3, 1)
    local endOptionIndex = math.min(startOptionIndex + 3, #options)

    for i = startOptionIndex, endOptionIndex do
        local option = options[i]
        local optionNameLength = djui_hud_measure_text(option.name)
        local optionPosX = screenWidth * 0.5 - optionNameLength * 0.5

        djui_hud_set_color(0, 0, 0, 128)
        djui_hud_print_text(option.name, optionPosX + 1, optionPosY + 1, 1)
        djui_hud_set_color(255, 255, 255, 255)

        if i == selectedOption then 
            djui_hud_set_color(0, 0, 0, 128)
            djui_hud_print_text(">", optionPosX - 15, optionPosY + 1, 1)		
            djui_hud_set_color(255, 255, 255, 255)
            djui_hud_print_text(">", optionPosX - 16, optionPosY, 1)		
        end

        djui_hud_print_text(option.name, optionPosX, optionPosY, 1)
        optionPosY = optionPosY + 20
    end

    local arrowUpPosY = screenHeight * 0.55 - 10
    local arrowDownPosY = screenHeight - 30
    local arrowDownPosX = screenWidth * 0.5 - djui_hud_measure_text(arrowDown) * 0.5
    local arrowUpPosX = screenWidth * 0.5 - djui_hud_measure_text(arrowUp) * 0.5

    if arrowUp ~= "" then
        djui_hud_print_text(arrowUp, arrowUpPosX, arrowUpPosY, 1)
    end
    if arrowDown ~= "" then
        djui_hud_print_text(arrowDown, arrowDownPosX, arrowDownPosY, 1)
    end
end

local function render_text(text)
    for _, data in ipairs(text) do
        djui_hud_set_font(data.font)
        djui_hud_set_color(0, 0, 0, 128)
        djui_hud_print_text(data.text, data.posX + 1, data.posY + 1, 1)
        if data.color then
            djui_hud_set_color(data.color.r, data.color.g, data.color.b, data.color.a)
        else
            djui_hud_set_color(255, 255, 255, 255)
        end
        djui_hud_print_text(data.text, data.posX, data.posY, 1)
    end
end

if _G.charSelectExists then
    if gGlobalSyncTable.popups == true then				
    djui_popup_create("You can enter to the CS Menu in the Pause Menu", 2)	
	end
end			

local function hud_render()
    if not isPaused then return end

    -- Character Select Support
    if _G.charSelectExists then
        local csOptionExists = false
        for _, option in ipairs(pauseMenuLevelOptions) do		
            if option.name == "CS MENU" then
                csOptionExists = true
                break
            end
        end
        if not csOptionExists then			
            table.insert(pauseMenuLevelOptions, {name = "CS MENU", func = open_cs})
        end

        if isPaused and _G.charSelect.is_menu_open() then
            close_menu()
        end
    end

    djui_hud_set_resolution(RESOLUTION_N64)
    djui_hud_set_font(FONT_TINY)
    local screenHeight = djui_hud_get_screen_height()
    local screenWidth = djui_hud_get_screen_width()
    local optionPosY = screenHeight * 0.55

    djui_hud_set_color(0, 0, 25, 128)
    djui_hud_render_rect(0, 0, screenWidth + 20, screenHeight)
    djui_hud_set_color(255, 255, 255, 255)

    m.freeze = 1
	if gNetworkPlayers[0].currLevelNum == LEVEL_BOB then
        courseName = "- Course 1 -"
	elseif gNetworkPlayers[0].currLevelNum == LEVEL_WF then
        courseName = "- Course 2 -"
    elseif gNetworkPlayers[0].currLevelNum == LEVEL_JRB then
        courseName = "- Course 3 -"
	elseif gNetworkPlayers[0].currLevelNum == LEVEL_CCM then
        courseName = "- Course 4 -"
	elseif gNetworkPlayers[0].currLevelNum == LEVEL_BBH then
        courseName = "- Course 5 -"
	elseif gNetworkPlayers[0].currLevelNum == LEVEL_HMC then
        courseName = "- Course 6 -"
	elseif gNetworkPlayers[0].currLevelNum == LEVEL_LLL then
        courseName = "- Course 7 -"
	elseif gNetworkPlayers[0].currLevelNum == LEVEL_SSL then
        courseName = "- Course 8 -"		
	elseif gNetworkPlayers[0].currLevelNum == LEVEL_DDD then
        courseName = "- Course 9 -"
	elseif gNetworkPlayers[0].currLevelNum == LEVEL_SL then
        courseName = "- Course 10 -"
	elseif gNetworkPlayers[0].currLevelNum == LEVEL_WDW then
        courseName = "- Course 11 -"
    elseif gNetworkPlayers[0].currLevelNum == LEVEL_TTM then
        courseName = "- Course 12 -"
	elseif gNetworkPlayers[0].currLevelNum == LEVEL_THI then
        courseName = "- Course 13 -"
	elseif gNetworkPlayers[0].currLevelNum == LEVEL_TTC then
        courseName = "- Course 14 -"
	elseif gNetworkPlayers[0].currLevelNum == LEVEL_RR then
        courseName = "- Course 15 -"
	elseif gNetworkPlayers[0].currLevelNum == LEVEL_CASTLE 
	or gNetworkPlayers[0].currLevelNum == LEVEL_CASTLE_GROUNDS 
	or gNetworkPlayers[0].currLevelNum == LEVEL_CASTLE_COURTYARD then
        courseName = "- HUB Course -"		
	elseif gNetworkPlayers[0].currLevelNum == LEVEL_WMOTR 
	or gNetworkPlayers[0].currLevelNum == LEVEL_SA
	or gNetworkPlayers[0].currLevelNum == LEVEL_PSS
    or gNetworkPlayers[0].currLevelNum == LEVEL_ENDING
    or gNetworkPlayers[0].currLevelNum == LEVEL_ZERO_LIFE 
    or gNetworkPlayers[0].currLevelNum == LEVEL_BORDER then
        courseName = "- Side Course -"	
	elseif gNetworkPlayers[0].currLevelNum == LEVEL_BITDW
	or gNetworkPlayers[0].currLevelNum == LEVEL_BITFS 
    or gNetworkPlayers[0].currLevelNum == LEVEL_BITS
    or gNetworkPlayers[0].currLevelNum == LEVEL_BOWSER_1
    or gNetworkPlayers[0].currLevelNum == LEVEL_BOWSER_2
    or gNetworkPlayers[0].currLevelNum == LEVEL_BOWSER_3 then
        courseName = "- Bowser Course -"	
	elseif gNetworkPlayers[0].currLevelNum == LEVEL_COTMC
    or gNetworkPlayers[0].currLevelNum == LEVEL_VCUTM
    or gNetworkPlayers[0].currLevelNum == LEVEL_TOTWC then
        courseName = "- Cap Course -"	
	end	
		local textlv1 = get_level_name(gNetworkPlayers[0].currCourseNum, gNetworkPlayers[0].currLevelNum, gNetworkPlayers[0].currAreaIndex)
		local romhackAuthor
		if game == GAME_BUILD_3313 then
		romhackAuthor = "by B3313 Team"
		else
        romhackAuthor = "by " ..levelinfo[gNetworkPlayers[0].currLevelNum].author			
		end
		
        local textPositions = {
            { text = "- OPTIONS -", font = FONT_HUD,  posX = screenWidth * 0.5   - djui_hud_measure_text("- OPTIONS -") * 1.0, posY = optionPosY - 30 },		
            { text = textlv1,       font = FONT_TINY, posX = screenWidth * 0.5   - djui_hud_measure_text(textlv1)       * 0.5, posY = optionPosY - 60 },
            { text = courseName,    font = FONT_TINY, posX = screenWidth * 0.5   - djui_hud_measure_text(courseName)    * 0.5, posY = optionPosY - 75 },			
            { text = "PAUSE MENU",  font = FONT_HUD,  posX = screenWidth * 0.5   - djui_hud_measure_text("PAUSE MENU"),        posY = optionPosY - 125 },		
            { text = romhackText,   font = FONT_TINY, posX = screenWidth * 0.5   - djui_hud_measure_text(romhackText)   * 0.5, posY = optionPosY - 105},
            { text = romhackAuthor, font = FONT_TINY, posX = screenWidth * 0.5   - djui_hud_measure_text(romhackAuthor) * 0.5, posY = optionPosY - 90},		
        }

        render_text(textPositions)

        djui_hud_set_font(FONT_TINY)
        if (gLevelValues.pauseExitAnywhere or (gMarioStates[0].action & ACT_FLAG_PAUSE_EXIT) ~= 0) then
            menu_controls(pauseMenuLevelOptions)
            render_options(pauseMenuLevelOptions, screenHeight, screenWidth, optionPosY)
			
        djui_hud_set_resolution(RESOLUTION_N64);
		djui_hud_set_font (FONT_MENU)		
		if gGlobalSyncTable.roundState == ROUND_STATE_ACTIVE then
		djui_hud_print_text("Level Number: " .. gGlobalSyncTable.level .. " /" .. FLOOD_LEVEL_COUNT, 3.5, 230, 0.15)
		else
		djui_hud_print_text("Next Level: " .. gGlobalSyncTable.level .. " /" .. FLOOD_LEVEL_COUNT, 3.5, 230, 0.15)		
        end		

        djui_hud_set_adjusted_color(255, 255, 255, 175)					
        djui_hud_render_texture(TEX_ROMHACK_LOGO, 5.5, 165, 0.6, 0.5)		
		
    end
end

local function pressed_pause()
    if get_dialog_id() >= 0 or (_G.charSelectExists and _G.charSelect.is_menu_open()) then
        return false
    end

    return gMarioStates[0].controller.buttonPressed & START_BUTTON ~= 0
end

function before_mario_update()
    local rTrigPressed = m.controller.buttonPressed & R_TRIG ~= 0

    if pressed_pause() then
        if not isPaused then
            isPaused = true
            selectedOption = 1
            m.controller.buttonPressed = 0
            play_sound(SOUND_MENU_PAUSE_HIGHPRIO, zero)
        else
            close_menu()
        end
    elseif rTrigPressed and isPaused then
        djui_open_pause_menu()
        m.controller.buttonPressed = 0
        play_sound(SOUND_MENU_EXIT_A_SIGN, zero)
    end
end

real_hook_event(HOOK_ON_HUD_RENDER, hud_render)
real_hook_event(HOOK_BEFORE_MARIO_UPDATE, before_mario_update)
real_hook_event(HOOK_ON_WARP, close_menu)
real_hook_event(HOOK_ON_LEVEL_INIT, function () restartLevelArea = gNetworkPlayers[0].currAreaIndex close_menu() end)